﻿static function rpg(){
	var newTemplate = {
		_root:{
			allowedCommands:[
				"comment", 
				"fadeMusic", 
				"fadeScreen", 
				"if", 
				"move", 
				"music", 
				"pause", 
				"removeSwf", 
				"setVariable", 
				"sound", 
				"swf", 
				"teleport", 
				"textbox", 
				"wait", 
				"while"
			],
			icon:		"tree_script",
			label:	null
		},
		
		
		comment:{
			allowedCommands:[],
			icon:		"tree_commentText",
			label:	function( thisData ){
				return (thisData.message) ? thisData.message : "---------------------------------";
			}
		},
		fadeMusic:{
			allowedCommands:[],
			icon:		"tree_fadeMusic",
			label:	"fade music to:  [volume]"
		},
		fadeScreen:{
			allowedCommands:[],
			icon:		"tree_fadeScreen",
			label:	function( thisData ){
				var suffix = ( thisData.fadeDir === "out" ) ? " out" : " in";
				var suffix2 = ( thisData.waitForEnd ) ? "   (wait)" : "";
				return "fade"+suffix + suffix2;
			}
		},// fadeScreen {}
		// if  (defined below)
		move:{
			allowedCommands:[
				"anim", 
				"appearance", 
				"direction", 
				"lookAt", 
				"moveAbsolute", 
				"moveRelative", 
				"moveWait"
			],
			icon:		"tree_moveScript",
			label:	"move:  [sprite]"
		},
		music:{
			allowedCommands:[],
			icon:		"tree_music",
			label:	"music:  [file]"
		},
		pause:{
			allowedCommands:[],
			icon:		function( thisData ){
				return ( thisData.isPaused ) ? "tree_pause" : "tree_unpause";
			},
			label:		function( thisData ){
				var prefix = ( thisData.isPaused ) ? "Disable " : "Enable ";
				return prefix + thisData.system;
			}
		},// pause {}
		removeSwf:{
			allowedCommands:[],
			icon:		"tree_removeSwf",
			label:	"remove:  [name]"
		},
		setVariable:{
			allowedCommands:[],
			icon:		"tree_variables",
			label:	function( thisData ){
				var varName = thisData.condition[0];
				var op = thisData.condition[1];
				var val = thisData.condition[2];
				// // remove variable path from varName
				var startAt = varName.lastIndexOf(".");
				if(startAt != -1)
					varName = varName.substr( startAt+1 );
				// // remove variable path from value
				if( isNaN(val)  &&  val.indexOf('"')==-1 )
				{		// it's not a number or string, so any "." indicate a variable path
					var startAt = val.lastIndexOf(".");
					if(startAt != -1)
						val = val.substr( startAt+1 );
				}
				// Display
				if(val == "\\delete"){
					return "delete:  "+varName;
				}
				else if(val == "\\object"){
					return "create:  "+varName;
				}
				else
				{
					return varName+" "+op+" "+val;
				}
			}// label()
		},// setVariable {}
		sound:{
			allowedCommands:[],
			icon:		function( thisData ){
				// display filename only
				var fileName = thisData.file;
				if( fileName.length > 0 )
				{// if:  play sound
					if( thisData.loop )
					{// if:  loop
						return "tree_sound_loop";
					}// if:  loop
					else
					{// if:  play once
						return "tree_sound_play";
					}// if:  play once
				}// if:  play sound
				else
				{// if:  stop sound
					return "tree_sound_stop";
				}// if:  stop sound
			},// icon()
			label:	function( thisData ){
				// display filename only
				var fileName = thisData.file;
				if( fileName.length > 0 )
				{// if:  play sound
					if( thisData.loop )
					{// if:  loop
						return "sound loop:  "+thisData.name;
					}// if:  loop
					else
					{// if:  play once
						var startAt = fileName.lastIndexOf( "/" );
						if(startAt != -1)
							fileName = fileName.substr( startAt+1 );
						// display
						return "sound:  "+fileName;
					}// if:  play once
				}// if:  play sound
				else
				{// if:  stop sound
					return "stop sound:  "+thisData.name;
				}// if:  stop sound
			}// label()
		},// sound {}
		// swf + textbox  (same command)
		swf:{
			allowedCommands:[],
			icon:		function( thisData ){
				if(thisData.data.type=="textbox"){		// textbox
					return "tree_textbox";
				}else{																// generic SWF
					if(thisData.linkage)
						return "tree_swf";
					else
						return "tree_removeSwf";
				}
			},// icon()
			label:	function( thisData ){
				if(thisData.data.type=="textbox"){		// textbox
					var nextLine = String.fromCharCode(10);									// 13 or 10		(flash uses 10)
					var endAt = thisData.data.text.indexOf( nextLine );
					if(endAt == -1)
						endAt = thisData.data.text.length;
					var firstLine = thisData.data.text.substr(0,endAt) || "";
					return "text:  "+firstLine;
				}
				else{																	// generic SWF
					if(thisData.linkage){
						return "swf:  "+thisData.name;
					}else{
						return "remove:  "+thisData.name;
					}
				}
			}// label()
		},// swf {}
		teleport:{
			allowedCommands:[],
			icon:		"tree_moveAbsolute",
			label:	function( thisData ){
				// level name  (no path)
				var fileName = thisData.level;
				var startAt = fileName.lastIndexOf( "\\" );
				if(startAt==-1)
					var startAt = fileName.lastIndexOf( "/" );
				if(startAt != -1)
					fileName = fileName.substr( startAt+1 );
				//
				var xTile = Math.round(thisData.position.x / 16);
				var yTile = Math.round(thisData.position.y / 16);
				// 
				return "teleport:  "+fileName+" ("+xTile+", "+yTile+")";
			}// label()
		},
		wait:{
			allowedCommands:[],
			icon:		"tree_wait",
			label:	function( thisData ){
				if(thisData.mode == "time"){							// wait for 0.5 sec
					// display number up to 2 decimal places
					var time_str = String(thisData.value);
					var endAt = time_str.indexOf(".");
					if(endAt==-1){
						endAt = time_str.length;		// integer:  read all digits
					}else{
						endAt+=3;										// decimal:  read 2 digits
					}
					time_str = time_str.substr( 0, endAt);
					// display
					return "wait for "+time_str+" sec";
				}
				else if(thisData.mode == "movement"){			// wait for spriteName
					return "wait for "+thisData.value;
				}
				else if(thisData.mode == "movieclip"){			// wait for spriteName
					var startAt = thisData.value.lastIndexOf(".");
					var showThis = thisData.value.substr(startAt+1);
					return "wait for clip: "+thisData.value;
				}
				else if(thisData.mode == "animation"){			// wait for spriteName
					return "wait for "+thisData.value;
				}
				else if(thisData.mode == "fadeMusic"){		// wait for music fade
					return "wait for music fade";
				}
				else if(thisData.mode == "sound"){		// wait for a sound
					return "wait for sound: "+thisData.value;
				}
				else if(thisData.mode == "script"){			// wait for spriteName
					return "wait for script: "+(thisData.value2 || "?");
				}
			}// label()
		},// wait {}
		// while  (defined below)
		
		
		anim:{
			allowedCommands:[],
			icon:		function( thisData ){
				if(thisData.value){
					return "tree_anim_on";
				}else{
					return "tree_anim_off";
				}
			},
			label:	function( thisData ){
				if(thisData.value){
					return "start animating";
				}else{
					return "stop animating";
				}
			}
		},// anim {}
		appearance:{
			allowedCommands:[],
			icon:		"tree_appearance",
			label:	function( thisData ){
				// display only the charset filename, no path
				var fileName = thisData.value.charset;
				var startAt = fileName.lastIndexOf( "/" );
				if(startAt != -1)
					fileName = fileName.substr( startAt+1 );
				// display
				return "pose:  "+fileName;
			}// label()
		},
		direction:{
			allowedCommands:[],
			icon:		"tree_look",
			label:	function( thisData ){
				var dir = thisData.value;
				if(dir==0){
					dir="up";
				}else if(dir==1){
					dir="right";
				}else if(dir==2){
					dir="down";
				}else if(dir==3){
					dir="left";
				}
				return "look:  "+thisData.value;
			}// label()
		},// direction {}
		lookAt:{
			allowedCommands:[],
			icon:		"tree_look",
			label:	"lookAt:  [value]"
		},
		moveAbsolute:{
			allowedCommands:[],
			icon:		"tree_moveAbsolute",
			label:	function( thisData ){
				var xTiles = Math.floor(thisData.position.x / 16);
				var yTiles = Math.floor(thisData.position.y / 16);
				return "moveTo:  "+xTiles+", "+yTiles;
			}// label()
		},
		moveRelative:{
			allowedCommands:[],
			icon:		"tree_moveRelative",
			label:	function( thisData ){
				var xTiles = Math.floor(thisData.position.x / 16);
				var yTiles = Math.floor(thisData.position.y / 16);
				return "move:  "+xTiles+", "+yTiles;
			}// label()
		},
		moveWait:{
			allowedCommands:[],
			icon:		"tree_wait",
			label:	function( thisData ){
				var thisDataMode = thisData.mode || "time";
				if(thisDataMode == "time"){							// wait for 0.5 sec
					// display number up to 2 decimal places
					var time_str = String(thisData.value);
					var endAt = time_str.indexOf(".");
					if(endAt==-1){
						endAt = time_str.length;		// integer:  read all digits
					}else{
						endAt+=3;										// decimal:  read 2 digits
					}
					time_str = time_str.substr( 0, endAt);
					// display
					return "wait for "+time_str+" sec";
				}
				else if(thisDataMode == "movement"){			// wait for spriteName
					return "wait for "+thisData.value;
				}
				else if(thisDataMode == "movieclip"){			// wait for spriteName
					var startAt = thisData.value.lastIndexOf(".");
					var showThis = thisData.value.substr(startAt+1);
					return "wait for clip: "+thisData.value;
				}
				else if(thisDataMode == "animation"){			// wait for spriteName
					return "wait for anim "+thisData.value;
				}
				else if(thisDataMode == "fadeMusic"){		// wait for music fade
					return "wait for music fade";
				}
				else if(thisDataMode == "sound"){		// wait for a sound
					return "wait for sound: "+thisData.value;
				}
				else if(thisDataMode == "script"){			// wait for spriteName
					return "wait for script: "+(thisData.value2 || "?");
				}
			}// label()
		} // moveWait {}
		
	}// newTemplate {}
	
	
	newTemplate["if"] = {
		allowedCommands:[
			"comment", 
			"fadeMusic", 
			"fadeScreen", 
			"if", 
			"move", 
			"music", 
			"pause", 
			"removeSwf", 
			"setVariable", 
			"sound", 
			"swf", 
			"teleport", 
			"textbox", 
			"wait", 
			"while"
		],
		icon:		"tree_if",
		label:	function( thisData ){
			var varName = thisData.condition[0];
			var op = thisData.condition[1];
			var val = thisData.condition[2];
			// // remove variable path from varName
			var startAt = varName.lastIndexOf(".");
			if(startAt != -1)
				varName = varName.substr( startAt+1 );
			// // remove variable path from value
			if( isNaN(val)  &&  val.indexOf('"')==-1 )
			{		// it's not a number or string, so any "." indicate a variable path
				var startAt = val.lastIndexOf(".");
				if(startAt != -1)
					val = val.substr( startAt+1 );
			}
			// Display
			return "if:  "+varName+" "+op+" "+val;
		}// label()
	}// if {}
	
	
	newTemplate["while"] = {
		allowedCommands:[
			"comment", 
			"fadeMusic", 
			"fadeScreen", 
			"if", 
			"move", 
			"music", 
			"pause", 
			"removeSwf", 
			"setVariable", 
			"sound", 
			"swf", 
			"teleport", 
			"textbox", 
			"wait", 
			"while"
		],
		icon:		"tree_while",
		label:	function( thisData ){
			var varName = thisData.condition[0];
			var op = thisData.condition[1];
			var val = thisData.condition[2];
			// // remove variable path from varName
			var startAt = varName.lastIndexOf(".");
			if(startAt != -1)
				varName = varName.substr( startAt+1 );
			// // remove variable path from value
			if( isNaN(val)  &&  val.indexOf('"')==-1 )
			{		// it's not a number or string, so any "." indicate a variable path
				var startAt = val.lastIndexOf(".");
				if(startAt != -1)
					val = val.substr( startAt+1 );
			}
			// Display
			return "loop while:  "+varName+" "+op+" "+val;
		}// label()
	}// while {}
	
	return newTemplate;
}// rpg()